//******************************************************************************
//
//	File:		InstantiateBRadioButton.h
//
//	Description:	Unarchiving a BRadioButton instance.
//
//	Copyright 1996, International Lorienne Inc.
//
//******************************************************************************

#include "RadioButton.h"
#include <string.h>

#pragma export on
BRadioButton* InstantiateBRadioButton(BMessage *message);
#pragma export off



BRadioButton* InstantiateBRadioButton(BMessage *message)
{
	BRadioButton	*instance;
	BRect	frame;
	char	*label;
	float	value;
	long	follow;
	rgb_color	color;

	// Default values
	
	frame.left = 10;
	frame.top = 10;
	frame.right = 90;
	frame.bottom = 30;
	label = strdup("RadioButton");
	follow = B_FOLLOW_LEFT | B_FOLLOW_TOP;
	color.red = 210;
	color.green = 210;
	color.blue = 210;
	bool enabled = TRUE;

	// Decode instance values
	
		
	if (message->HasPoint("Origin")) {
		BPoint origin = message->FindPoint("Origin");
		value = frame.Width();
		frame.left = origin.x;
		frame.right = frame.left + value;
		value = frame.Height();
		frame.top = origin.y;
		frame.bottom = frame.top + value;
	}	
	if (message->HasRect("Frame")) {
		frame = message->FindRect("Frame");
	}	
	if (message->HasString("Label")) {
		label = strdup(message->FindString("Label"));
	}	
	if (message->HasLong("Follow Mode")) {
		follow = message->FindLong("Follow Mode");
	}	
	if (message->HasBool("Enabled")) {
		enabled = message->FindBool("Enabled");
	}	
	if (message->HasLong("Value")) {
		value = message->FindLong("Value");
	}	

	instance = new BRadioButton(frame,"BRadioButton",label,NULL,follow);

	free(label);

	instance->SetEnabled((bool)enabled);
	if (message->HasString("Font Name")) {
		instance->SetFontName(message->FindString("Font Name"));
	}	
	
	
	return instance;
}
